/* Wiktor Zychla, 2003 */
using System;
using System.Collections;

namespace Example
{
  public class COsoba : IComparable
  {
    public class COsobaSortByDataUr : IComparer
    {
      public int Compare( object obj1, object obj2 )
      {
        COsoba o1 = obj1 as COsoba;
        COsoba o2 = obj2 as COsoba;
        
        return o1.dataUr.CompareTo( o2.dataUr );
      }
      public COsobaSortByDataUr() {}
    }

    public string   imie;
    public string   nazwisko;
    public DateTime dataUr;

    public int CompareTo( object o )
    {
      if ( o is COsoba )
      {
        COsoba o2 = o as COsoba;
        
        if ( this.nazwisko == o2.nazwisko )
          return this.imie.CompareTo( o2.imie );
        else
          return this.nazwisko.CompareTo( o2.nazwisko );
      }
      else
        return -1;
    }

    public override string ToString()
    {
      return String.Format( "{0} {1}, ur. {2:d}", nazwisko, imie, dataUr );
    } 

    public COsoba( string imie, string nazwisko, string dataUr )
    {
      this.imie   = imie; this.nazwisko = nazwisko; 
      this.dataUr = DateTime.Parse( dataUr );
    } 
  }

  public class CExample 
  {
    static void Wypisz( IEnumerable ie )
    {
       Console.WriteLine();
       foreach ( object o in ie )
         Console.WriteLine( "{0},", o );
    }

    public static void Main(string[] args)
    {
       ArrayList atab = new ArrayList();		

       atab.Add( new COsoba( "Jan",      "Kowalski", "1994-03-01" ) );
       atab.Add( new COsoba( "Zdzisaw", "Kowalski", "1992-11-29" ) );
       atab.Add( new COsoba( "Jan",    "Malinowski", "1990-02-16" ) );
       atab.Add( new COsoba( "Tomasz",   "Abacki"  , "1991-01-12" ) );

       Wypisz( atab );
       atab.Sort();
       Wypisz( atab );
       atab.Sort( new COsoba.COsobaSortByDataUr() );
       Wypisz( atab );

    }
  }
}
